/*:
 * @target MZ
 * @plugindesc Fügt flackernden Leuchteffekt für Events hinzu, um Kerzenschein zu simulieren
 * @author KhaosEden
 * @command Leuchten
 * @text Leuchten
 * @desc Lässt ein Event flackern wie eine Kerze.
 * @arg eventId
 * @type number
 * @text Event ID
 * @desc Die ID des Events, das leuchten soll.
 * @default 1
 * @arg intensity
 * @type number
 * @text Intensität
 * @desc Die Grundhelligkeit des Leuchteffekts. Werte von 0.1 bis 5.0 empfohlen.
 * @default 2
 * @arg color
 * @type select
 * @option Gelb
 * @value gelb
 * @option Rot
 * @value rot
 * @option Blau
 * @value blau
 * @option Weiss
 * @value weiss
 * @option Schwarz
 * @value schwarz
 * @option Lila
 * @value lila
 * @option Orange
 * @value orange
 * @option Pink
 * @value pink
 * @option Grün
 * @value gruen
 * @text Farbe
 * @desc Die Farbe des Leuchteffekts.
 * @default gelb
 */

(() => {
    const colorMap = {
        gelb: 0xFFFF00,
        rot: 0xFF0000,
        blau: 0x0000FF,
        weiss: 0xFFFFFF,
        schwarz: 0x000000,
        lila: 0x800080,
        orange: 0xFFA500,
        pink: 0xFFC0CB,
        gruen: 0x00FF00
    };

    PluginManager.registerCommand("Leuchten", "Leuchten", args => {
        const eventId = Number(args.eventId);
        const intensity = Number(args.intensity);
        const color = args.color.toLowerCase();

        const event = $gameMap.event(eventId);
        if (event) {
            console.log(`Leuchteffekt aktiviert für Event ID: ${eventId} mit Intensität: ${intensity} und Farbe: ${color}`);
            event._lightIntensity = intensity;
            event._isGlowing = true;
            event._glowFrame = 0; // Frame-Zähler für die Schwankungsanimation
            event._glowColor = colorMap[color] || 0xFFFF00; // Standardfarbe Gelb
        } else {
            console.warn(`Event mit ID ${eventId} nicht gefunden!`);
        }
    });

    const _Sprite_Character_update = Sprite_Character.prototype.update;
    Sprite_Character.prototype.update = function() {
        _Sprite_Character_update.call(this);

        const character = this._character;
        if (character && character._isGlowing) {
            // Füge GlowFilter hinzu, wenn er nicht existiert
            if (!this.filters) {
                const glowFilter = new PIXI.filters.GlowFilter({
                    distance: 15,
                    outerStrength: character._lightIntensity,
                    innerStrength: 0,
                    color: character._glowColor,
                    quality: 0.5
                });
                this.filters = [glowFilter];
            }

            // Erhöhe Frame-Zähler für die Flackeranimation langsamer
            character._glowFrame += 0.07; // Anpassbare Geschwindigkeit (langsamer als 0.1)
            const fluctuation = 1 + 0.3 * Math.sin(character._glowFrame); // Schwankt zwischen 0.7 und 1.3
            this.filters[0].outerStrength = character._lightIntensity * fluctuation;
        } else {
            // Entferne Filter, wenn das Event nicht leuchtet
            this.filters = null;
        }
    };
})();
